const puppeteer = require('puppeteer');
const fs = require('fs');
const cors = require('cors');
const express = require('express');
const app = express();
app.use(express.json({ strict: false }));
app.use(express.urlencoded({ extended: false }));
app.use(cors());

const port = 19199;

let browser;

(async () => {

  app.post('/html2pdf', async (request, response) => {
    try {
      console.log(request.body)
      await html2pdf(request.body.htmlPath, request.body.pdfPath, request.body.chromiumPath);
      response.json({ success: true });
    } catch(e) {
      console.log(e);
      response.json({ success: false });
    }    
  });

  app.get('/', (req, res) => {
    res.send('MSC-HTML2PDF');
  });

  app.listen(port, () => {
    console.log(`MSC-HTML2PDF server listening on port ${port}!`)
  })

  const html2pdf = async (htmlPath, pdfPath, chromiumPath) => {
    if(!browser) {
      browser = await puppeteer.launch({
        headless: true,
        executablePath: chromiumPath
      });
    }
    // Create a new page
    const page = await browser.newPage();
    //Get HTML content from HTML file
    const html = fs.readFileSync(htmlPath, 'utf-8');
    await page.setContent(html, { waitUntil: 'domcontentloaded' });
  
    // To reflect CSS used for screens instead of print
    await page.emulateMediaType('screen');
  
    // Download the PDF
    const pdf = await page.pdf({
      path: pdfPath,
      margin: { top: '0px', right: '0px', bottom: '0px', left: '0px' },
      printBackground: true,
      format: 'A4',
    });
    await page.close();
  }
})();